# Cuadro VI.1

# Ajustes de distribuciones con el test X^2 y el test de Kolmogorov-Smirnov

########################################################
# Seccin modificable por el usuario
########################################################

# Lectura de la base de datos
datos<-read.csv2("Cuadro VI.1.V.csv",enc="latin1")

# Seleccin de las variables de inters
# varInteres<-c("Zona1")
varInteres<-c("Zona1","Zona2")

# Seleccin de categorizacin de las variables
# Si no se utilizan variables de agrupacin obligatoriamente
# se exige que se coloce varAgrupacin como NULL
# varAgrupacion<-NULL
varAgrupacion<-c("Especie")
#varAgrupacion<-c("Gnero","Especie")


# Distribucin para la cual se quiere hacer el hacer el ajuste
# 1. Binomial
# 2. Poisson
distribucion<-2

# Combine categoras inferior a 5?
combinar<-"si"

# Grfica comparativa
grafica<-"si"

# Nombre del archivo de salida
ArchivodeSalida<-"Salida Cuadro VI.1.V.csv"

# Titulo genrico del eje x.
tituloEjeX<-"Abundancia"

########################################################
# Seccin que realiza el procedimiento
########################################################
# Paquetes necesarios
require(MASS)

# Funcin para colapsar categoras de valores esperados
# inferiores a un lmite predeterminado.
colapsar<-function(p1,f1,lim1=5){
  #if (){
  # return(list(probs=NA,freqs=NA))
  #}
  np1<-p1
  nf1<-f1
  tocollapse<-which((np1*sum(nf1))<lim1)
  while(length(tocollapse)>0){
   x<-tocollapse[1]
   if (x<length(np1)){
    np1[x+1]<-p1[x]+p1[x+1]
    nf1[x+1]<-f1[x]+f1[x+1]
   }else{
    np1[x-1]<-p1[x]+p1[x-1]
    nf1[x-1]<-f1[x]+f1[x-1]
   }
   p1<-np1[-x]
   f1<-nf1[-x]
   np1<-p1
   nf1<-f1
   tocollapse<-which((p1*sum(f1))<lim1)
  }
  return(list(probs=p1,freqs=f1))  
 }


calculos<-function(x){
 x<-x[!is.na(x)]
 if(length(x)>2 & length(table(x))>1){
 if(distribucion==1){
   n<-max(x)
   media<-mean(x)
   prob1<-media/n
  # Prueba de Kolmogorov-Smirnov.
   pruebaks<-ks.test(x,"pbinom",size=n,prob=prob1)
  # Prueba de chi-cuadrado.
   frecObs<-table(x)
   print(frecObs)
   probEsp<-dbinom(0:n,size=n,prob=prob1)
   frecObs2<-rep(0,length(probEsp))
   frecObs2[as.integer(names(frecObs))+1]<-as.vector(unlist(frecObs))
   frecObs<-frecObs2
   frecEsp<-probEsp*sum(frecObs)
   tablas<-data.frame(frecObs=as.vector(frecObs),frecEsp=frecEsp,probEsp=probEsp)
   # Colapsar categoras con frecuencias esperadas inferiores a 5.
   if (toupper(combinar)=="SI"){
       r1<-colapsar(probEsp,frecObs)
       frecObsC<-r1$freqs
       probEspC<-r1$probs
      if(length(frecObsC)>1) pruebaChisq<-chisq.test(frecObsC,p=probEspC) else pruebaChisq<-NA
   }else{
   pruebaChisq<-chisq.test(frecObs,p=probEsp)
   }
   if (!is.na(pruebaChisq[1]) & pruebaChisq$parameter > 1 ){
       r<-c(pruebaks$statistic,pruebaks$p.value,pruebaChisq$statistic,
           pruebaChisq$parameter-1,1-pchisq(pruebaChisq$statistic,pruebaChisq$parameter-1))
      }else{
       r<-c(pruebaks$statistic,pruebaks$p.value,rep(NA,3))
     }
  } else if(distribucion==2){
    # Clculo del parmetro de la distribucion utilizando el momento.
    lambda<-mean(x)
    # Prueba de Kolmogorov-Smirnov.
    pruebaks<-ks.test(x,"ppois",lambda=lambda)
    # Prueba de chi-cuadrado.
    frecObs<-table(x)
    #probEsp<-dpois(as.integer(names(frecObs)[-length(frecObs)]),lambda=lambda)
    probEsp<-dpois(0:as.integer(names(frecObs)[length(frecObs)]),lambda=lambda)
    probEsp[length(probEsp)]<-probEsp[length(probEsp)]+(1-ppois(as.integer(names(frecObs)[length(frecObs)]),lambda=lambda))
    frecObs2<-rep(0,length(probEsp))
    frecObs2[as.integer(names(frecObs))+1]<-as.vector(unlist(frecObs))
    frecObs<-frecObs2    
    frecEsp<-probEsp*sum(frecObs)
    tablas<-data.frame(frecObs=as.vector(frecObs),frecEsp=frecEsp,probEsp=probEsp)
    # Colapsar categoras con frecuencias esperadas inferiores a 5.
    if (toupper(combinar)=="SI"){
    r1<-colapsar(probEsp,frecObs)
    frecObsC<-r1$freqs
    probEspC<-r1$probs
     if(length(frecObsC)>1) pruebaChisq<-chisq.test(frecObsC,p=probEspC) else pruebaChisq<-NA
    }else{
    pruebaChisq<-chisq.test(frecObs,p=probEsp)
    }
    if (!is.na(pruebaChisq[1]) & pruebaChisq$parameter > 1 ){
	r<-c(pruebaks$statistic,pruebaks$p.value,pruebaChisq$statistic,
            pruebaChisq$parameter-1,1-pchisq(pruebaChisq$statistic,pruebaChisq$parameter-1))
	}else{
	r<-c(pruebaks$statistic,pruebaks$p.value,rep(NA,3))
      }
  } else r<-rep(NA,7)
  return(r)
}
}


generaGrafica<-function(i,lista,distribucion=1){
     x<-lista[[i]]
     x<-x[!is.na(x)]
     maxD<-max(density(x)$y)
     if (distribucion==2){
      lambda<-mean(x)
      probEspG<-dpois(0:(max(x)+2),lambda=lambda)
      x11()
      truehist(x,main=paste("Comparacin de distribuciones","\n",nomDist),
		xlab=tituloEjeX,ylab="Densidad",sub=nombres[[i]],
		xlim=c((min(x)-1),(max(x)+2)),ymax=max(max(probEspG),maxD)*1.2)
      lines(0:(max(x)+2),probEspG,type="s",col="red",lty=2,lwd=2)
      legend("topleft",legend=c("Dist. original","Dist. terica"),
		      lwd=c(1,2),lty=2,col=c("black","red"))
     } else if(distribucion==1) {
      n<-max(x)
      media<-mean(x)
      prob1<-media/n
      probEspG<-dbinom(0:(max(x)+2),size=n,prob=prob1)
      x11()
      truehist(x,main=paste("Comparacin de distribuciones","\n",nomDist),
		xlab=tituloEjeX,ylab="Densidad",sub=nombres[[i]],
		xlim=c((min(x)-1),(max(x)+2)),ymax=max(max(probEspG),maxD)*1.2)
      lines(0:(max(x)+2),probEspG,type="s",col="red",lty=2,lwd=2)
      legend("topleft",legend=c("Dist. original","Dist. terica"),
		      lwd=c(1,2),lty=2,col=c("black","red"))
     }
     invisible()
  }

# Seleccin del nombre de la distribucin
switch(distribucion,
       nomDist<-"Binomial",
       nomDist<-"Poisson")

# Organizacin de la base de datos.
valores<-unlist(datos[,varInteres])
variables<-factor(rep(varInteres,each=dim(datos)[1]))
agrupaciones<-data.frame(datos[rep(1:dim(datos)[1],length(varInteres)),varAgrupacion])
names(agrupaciones)<-varAgrupacion

datos2<-data.frame(agrupaciones,variable=variables,valor=valores)

varAgrupacion<-c(varAgrupacion,"variable")

agrupa<-data.frame(datos2[,varAgrupacion])
if(length(varAgrupacion)==1) names(agrupa)<-varAgrupacion

listadatos2<-split(datos2$valor,as.list(agrupa),drop=TRUE)

nombres<-names(listadatos2)
r1<-t(sapply(listadatos2,calculos))
r1<-data.frame(nombres=rownames(r1),r1)
if (toupper(combinar)=="SI") {
names(r1)<-c("nombres","D de K-S","Valor-p K-S","X Chisq2","Grados de libertad ajustado","Valor-p Chisq2 ajustado")
}else{
names(r1)<-c("nombres","D de K-S","Valor-p K-S","X Chisq2","Grados de libertad","Valor-p Chisq2")
}
r2<-data.frame(nombres=apply(agrupa,1,paste,collapse="."),agrupa)
r2<-r2[!duplicated(r2$nombres),]
tablas<-merge(r2,r1,"nombres")



########################################################
# Seccin que muestra los resultados
########################################################
cat("Tablas de las categoras\n")
tablas

if (!is.null(ArchivodeSalida)) write.csv2(tablas,ArchivodeSalida,row.names=FALSE)

if (toupper(grafica)=="SI"){
  sapply(1:length(listadatos2),generaGrafica,listadatos2,distribucion)  
}
